
// BISlipTemplate.h
// BISubstrate
// 
// Copyright (c) 2001 Marketcircle Inc. All rights reserved.

/*!
    @class       BISlipTemplate
    @abstract    BISlipTemplate represents a blueprint or defaults which will be copied/applied to a slip when it is created from a template.
    @discussion  Allows the user to specify defaults which are commonly set/used when they create slips of a particular type.  This saves them time rather than having to enter the same common information over and over every time they create a slip.  ie. Create an Icon might be a common slip and they can create a slip template (blue print) for that.
*/


#ifdef BILLINGS_PRO
#import "_BPSlipTemplate.h"
#endif
#ifdef BILLINGS_SINGLE
#import "_BISlipTemplate.h"
#endif
#import "BIAppVersioning.h"


@interface BISlipTemplate : BL_SUPER_CLASSNAME_MUNGE(SlipTemplate) 
{
}

- (void)setDefaultValues;

- (void)setInitialValues;
- (void)setInitialValuesWithObjectContext:(id)oc;

- (void)copyValuesFromSlip:(id)aSlip;

- (NSNumber *)total;
- (NSString *)formattedTotal;

- (NSString*)workerName;

@end
